import React, { Component } from 'react';
import List from './List';

interface Props {
  contacts: any[];
  onSave: () => void;
  onDelete: () => void;
  accountId: number;
}

interface State {
  offset: number;
  span: number;
  total: number;
  isLoading: boolean;
  isEof: boolean;
}

class Contacts extends Component<Props, State> {
  public static OFFSET = 4;

  public static defaultProps = {
    contacts: [],
    onSave: () => {},
    onDelete: () => {},
    accountId: undefined,
  };

  public constructor(props) {
    super(props);

    this.state = {
      offset: Contacts.OFFSET,
      span: Contacts.OFFSET,
      total: props.contacts.length,
      isLoading: false,
      isEof: props.contacts.length <= Contacts.OFFSET,
    };
  }

  public componentWillReceiveProps(newProps) {
    const { contacts } = this.props;
    const newContacts = newProps.contacts;
    const diff = newContacts.length - contacts.length;

    if (diff > 0 || diff < 0) {
      this.setState(
        state => ({
          total: state.total + diff,
        }),
        () => {
          this.onLoad(diff);
        },
      );
    }
  }

  private onLoad = diff => {
    const { contacts } = this.props;

    this.setState(
      state => {
        const newOffset = state.offset + (diff || state.span);

        return {
          isLoading: true,
          offset: newOffset,
          isEof: newOffset >= contacts.length,
        };
      },
      () => {
        setTimeout(() => {
          this.setState({
            isLoading: false,
          });
        }, 1000);
      },
    );
  };

  public render() {
    const { contacts, accountId, ...rest } = this.props;

    return (
      <List
        {...rest}
        onLoad={this.onLoad}
        items={contacts.slice(0, this.state.offset)}
        isLoading={this.state.isLoading}
        isEof={this.state.isEof}
        accountId={accountId}
      />
    );
  }
}

export default Contacts;
