import * as React from 'react';
import Access from 'utils/Access';
import createI18N from '@yandex-int/i18n';
import * as keyset from '../contacts.i18n';
import List from './List';

const i18n = createI18N(keyset);
const i18nManual = i18n('manual');
const i18nImported = i18n('imported');

const DATA_CONTACTS = {
  NAME: 'contacts',
  TITLE: i18nManual,
};

const DATA_KIKS = {
  NAME: 'importedKiks',
  TITLE: i18nImported,
};

const ContactsView = (props) => {
  const { contacts, importedKiks, activeTab, access, ...rest } = props;

  let tab;

  if (activeTab === DATA_CONTACTS.NAME) {
    tab = <List contacts={contacts} {...rest} canEdit={Access.isEdit(access)} />;
  } else {
    tab = <List contacts={importedKiks} {...rest} />;
  }

  return tab;
};

ContactsView.TABS = [DATA_CONTACTS, DATA_KIKS];

export default ContactsView;
