import React from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';
import ToolTip from 'lego/components/ToolTip';
import cx from 'classnames';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as keyset from './Contract.i18n';
import css from './styles.modules.scss';

const i18nContract = createI18N(keyset)('contract');
const i18nRaw = createI18NRaw(keyset);

const formattedDate = date => (
  <FormattedDate value={date} day="numeric" month="short" year="numeric" />
);

const ContractsItemInfo = props => {
  const {
    className,
    data: { contractId, contractNum, startDate, endDate, paymentType },
  } = props;

  const popup = (
    <div>
      <div>
        <span className={css.label}>{i18nContract}</span>
        <span className={css.dates}>
          {i18nRaw('dates', {
            from: <span className={css.date}>{formattedDate(new Date(startDate))}</span>,
            to: <span className={css.date}>{formattedDate(new Date(endDate))}</span>,
          })}
        </span>
      </div>
    </div>
  );

  return (
    <div className={cx(className, css.root)}>
      <ToolTip tooltip={popup} stopPropagation size="xs">
        <a
          className={css.title}
          href={`https://admin.balance.yandex.ru/contract.xml?contract_id=${contractId}`}
          target="_blank"
          rel="noopener noreferrer"
        >
          {contractNum}
        </a>
      </ToolTip>
      {paymentType && <span className={css.payment}> – {paymentType}</span>}
    </div>
  );
};

ContractsItemInfo.propTypes = {
  className: PropTypes.string,
  data: PropTypes.shape({
    contractId: PropTypes.number,
    contractNum: PropTypes.number,
    startDate: PropTypes.string,
    endDate: PropTypes.string,
    paymentType: PropTypes.string,
  }),
};

ContractsItemInfo.defaultProps = {
  className: undefined,
  data: {},
};

export default ContractsItemInfo;
