import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { jsonApiCall } from 'api/common';
import { InfiniteListView } from 'containers/InfiniteList';
import Empty from 'components/Empty';
import createI18N from '@yandex-int/i18n';
import * as keyset from './Contracts.i18n';
import Contract from '../Contract';
import css from './styles.modules.scss';

const i18nNoData = createI18N(keyset)('noData');

class Contracts extends Component {
  componentDidMount() {
    this.props.loadList();
  }

  onLoad = args => {
    const { clientId } = this.props;

    return jsonApiCall({
      url: `/view/client/${clientId}/contracts`,
      data: {
        ...args,
      },
      global: false,
    });
  };

  render() {
    return (
      <div className={css.root}>
        <InfiniteListView
          className={css.contracts}
          name={this.props.name}
          onLoad={this.onLoad}
          component={Contract}
          withNavigation={false}
          emptyComponent={<Empty text={i18nNoData} icon="storage" />}
        />
      </div>
    );
  }
}

Contracts.propTypes = {
  name: PropTypes.string.isRequired,
  loadList: PropTypes.func,
  clientId: PropTypes.number.isRequired,
};

Contracts.defaultProps = {
  loadList: () => {},
};

export default Contracts;
