import React from 'react';
import { ExternalLink } from 'components/ExternalLinks';
import { FormattedNumber } from 'react-intl';

interface Props {
  className: string;
  columnsStyle: any;
  cellClassName: string;
  index: number;
  item: any;
  columns: any;
}

const Domain = (props: Props) => {
  const { item, index, cellClassName, columnsStyle, className, columns } = props;

  return (
    <span className={className}>
      <div className={cellClassName} style={columnsStyle.index}>
        {index}
      </div>
      {columns.map(column => {
        const { name, type } = column;
        const value = item[name];
        let renderVal: string | React.ReactNode = '\u2014';
        if (value != null) {
          switch (type) {
            case 'money':
              // eslint-disable-next-line react/style-prop-object
              renderVal = <FormattedNumber value={value} style="currency" currency="RUB" />;
              break;
            case 'link':
              renderVal = <ExternalLink value={value} />;
              break;
            default:
              renderVal = value;
          }
        }

        return (
          <div key={name} data-type={type} className={cellClassName} style={columnsStyle[name]}>
            {renderVal}
          </div>
        );
      })}
    </span>
  );
};

Domain.defaultProps = {
  columnsStyle: {},
};

export default Domain;
