import React from 'react';
import { TableView } from 'containers/InfiniteList';
import { FormattedDate } from 'react-intl';
import Empty from 'components/Empty';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as keyset from '../domains.i18n';
import Domain from './Domain';

const i18n = createI18N(keyset);
const i18nRaw = createI18NRaw(keyset);
const i18nDomain = i18n('domain');
const i18nTotalWeek = i18n('totalWeek');
const i18nTacWeek = i18n('tacWeek');
const i18nNothingFound = i18n('nothingFound');
const i18nNoData = i18n('noData');

const getTableSettings = (sysDates = {}) => ({
  columnVisibility: {
    domain: true,
    w0Total: true,
    m1Total: true,
    w12Pct: true,
    w0Tac: true,
    m1Tac: true,
    w12TacPct: true,
  },
  grid: {
    columns: [
      { name: 'domain', title: i18nDomain, type: 'link' },
      {
        name: 'w0Total',
        title: (
          <span>
            {i18nRaw('totalFor', {
              date: <FormattedDate value={new Date(sysDates.w0)} month="short" />,
            })}
          </span>
        ),
        type: 'money',
      },
      {
        name: 'm1Total',
        title: (
          <span>
            {i18nRaw('totalFor', {
              date: <FormattedDate value={new Date(sysDates.m1)} month="short" />,
            })}
          </span>
        ),
        type: 'money',
      },
      { name: 'w12Pct', title: i18nTotalWeek, type: 'money' },
      {
        name: 'w0Tac',
        title: (
          <span>
            {i18nRaw('tacFor', {
              date: <FormattedDate value={new Date(sysDates.sday01)} month="short" />,
            })}
          </span>
        ),
        type: 'money',
      },
      {
        name: 'm1Tac',
        title: (
          <span>
            {i18nRaw('tacFor', {
              date: <FormattedDate value={new Date(sysDates.m1)} month="short" />,
            })}
          </span>
        ),
        type: 'money',
      },
      { name: 'w12TacPct', title: i18nTacWeek, type: 'money' },
    ],
  },
  flexRatio: {
    domain: 2,
    default: 1,
  },
});

class DomainTable extends React.PureComponent {
  constructor(props) {
    super(props);

    this.tableSettings = getTableSettings(this.props.sysDates);
  }

  render() {
    const { items, isEmpty, isSearch } = this.props;

    if (isEmpty) {
      if (isSearch) {
        return <Empty text={i18nNothingFound} icon="search" />;
      }
      return <Empty text={i18nNoData} icon="storage" />;
    }

    return (
      <TableView
        rowComponent={Domain}
        items={items}
        isLoad
        selectedId={-1}
        withNavigation={false}
        {...this.tableSettings}
      />
    );
  }
}

export default DomainTable;
