import React from 'react';
import Block from 'pages/accounts/modules/info/components/Block';
import Textinput from '@crm/components/dist/lego2/Textinput';
import createI18N from '@yandex-int/i18n';
import * as keyset from '../domains.i18n';
import DomainTable from './DomainTable';

const i18n = createI18N(keyset);
const i18nDomains = i18n('domains');
const i18nSearch = i18n('search');

interface Props {
  onSearch: (text: string) => void;
  isSearch: boolean;
  isEmpty: boolean;
  search: string;
  items: any;
  sysDates: any;
  access: number;
}

const style = {
  maxHeight: 400,
};

const Domains = (props: Props) => {
  const { onSearch, isSearch, isEmpty, search, items, access, sysDates } = props;

  return (
    <Block
      style={style}
      color="#66C7FF"
      access={access}
      title={i18nDomains}
      padding={false}
      right={
        (isSearch || !isEmpty) && (
          <Textinput value={search} onChange={onSearch} placeholder={i18nSearch} />
        )
      }
    >
      <DomainTable items={items} isSearch={isSearch} isEmpty={isEmpty} sysDates={sysDates} />
    </Block>
  );
};

export default Domains;
