import React from 'react';
import debounce from 'lodash/debounce';
import escapeRegExp from 'lodash/escapeRegExp';
import filterTree from 'utils/filterTree';
import Domains from './Domains';

interface Props {
  items: any;
  sysDates: any;
  access: number;
}

interface State {
  items: any;
  search: string;
  isSearch: boolean;
}

class DomainsContainer extends React.Component<Props, State> {
  public constructor(props) {
    super(props);

    this.filter = debounce(this.filter, 500);
    this.state = {
      search: '',
      items: props.items,
      isSearch: false,
    };
  }

  private handleSearch = (value: string) => {
    this.setState({ search: value });
    this.filter(value);
  };

  private filter = (value: string) => {
    if (value) {
      const searchPattern = new RegExp(`(${escapeRegExp(value)})`, 'im');

      const predicate = node => searchPattern.test(node.domain);

      const newFactors = filterTree({ node: { content: this.props.items }, predicate });

      this.setState({ items: newFactors && newFactors.content, isSearch: true });
    } else {
      this.setState({ items: this.props.items, isSearch: false });
    }
  };

  public render() {
    const { items } = this.state;
    const isEmpty = !(items && items.length);

    return (
      <Domains onSearch={this.handleSearch} isEmpty={isEmpty} {...this.props} {...this.state} />
    );
  }
}

export default DomainsContainer;
