import React from 'react';

interface Props {
  className: string;
  columnsStyle: any;
  cellClassName: string;
  index: number;
  item: any;
}

const Factor = (props: Props) => {
  const { item, index, cellClassName, columnsStyle, className } = props;

  return (
    <span className={className}>
      <div className={cellClassName} style={columnsStyle.index}>
        {index}
      </div>
      <div title={item.description} className={cellClassName} style={columnsStyle.name}>
        {item.name}
      </div>
      <div className={cellClassName} style={columnsStyle.value}>
        {item.value}
      </div>
    </span>
  );
};

Factor.defaultProps = {
  columnsStyle: {},
};

export default Factor;
