import React from 'react';
import { TableView } from 'containers/InfiniteList';
import Empty from 'components/Empty';
import createI18N from '@yandex-int/i18n';
import * as keyset from '../factors.i18n';
import Factor from './Factor';

const i18n = createI18N(keyset);
const i18nName = i18n('name');
const i18nValue = i18n('value');
const i18nNothingFound = i18n('nothingFound');
const i18nNoData = i18n('noData');

const TABLE_SETTINGS = {
  columnVisibility: {
    name: true,
    value: true,
  },
  grid: {
    columns: [
      { name: 'name', title: i18nName },
      { name: 'value', title: i18nValue },
    ],
  },
  flexRatio: {
    name: 2,
    default: 1,
  },
};

const FactorTable = props => {
  const { factors, isEmpty, isSearch } = props;

  if (isEmpty) {
    if (isSearch) {
      return <Empty text={i18nNothingFound} icon="search" />;
    }
    return <Empty text={i18nNoData} icon="storage" />;
  }

  return (
    <TableView
      rowComponent={Factor}
      items={factors}
      isLoad
      selectedId={-1}
      withNavigation={false}
      {...TABLE_SETTINGS}
    />
  );
};

export default FactorTable;
