import React from 'react';
import Block from 'pages/accounts/modules/info/components/Block';
import Textinput from '@crm/components/dist/lego2/Textinput';
import createI18N from '@yandex-int/i18n';
import * as keyset from '../factors.i18n';
import FactorTable from './FactorTable';

const i18n = createI18N(keyset);
const i18nDirectSettings = i18n('directSettings');
const i18nFactorSearch = i18n('factorSearch');

interface Props {
  onSearch: (text: string) => void;
  isSearch: boolean;
  isEmpty: boolean;
  search: string;
  factors: any;
  access: number;
}

const style = {
  maxHeight: 400,
};

const Factors = (props: Props) => {
  const { onSearch, isSearch, isEmpty, search, factors, access } = props;

  return (
    <Block
      style={style}
      color="#66C7FF"
      access={access}
      title={i18nDirectSettings}
      padding={false}
      right={
        (isSearch || !isEmpty) && (
          <Textinput value={search} onChange={onSearch} placeholder={i18nFactorSearch} />
        )
      }
    >
      <FactorTable factors={factors} isSearch={isSearch} isEmpty={isEmpty} />
    </Block>
  );
};

export default Factors;
