import React from 'react';
import debounce from 'lodash/debounce';
import escapeRegExp from 'lodash/escapeRegExp';
import filterTree from 'utils/filterTree';
import Factors from './Factors';

interface Props {
  factors: any;
  access: number;
}

interface State {
  factors: any;
  search: string;
  isSearch: boolean;
}

class FactorsContainer extends React.Component<Props, State> {
  public constructor(props) {
    super(props);

    this.filter = debounce(this.filter, 200);
    this.state = {
      search: '',
      factors: props.factors,
      isSearch: false,
    };
  }

  private handleSearch = (value: string) => {
    this.setState({ search: value });
    this.filter(value);
  };

  private filter = value => {
    if (value) {
      const searchPattern = new RegExp(`(${escapeRegExp(value)})`, 'im');

      const predicate = node =>
        searchPattern.test(node.name) || searchPattern.test(node.description);

      const newFactors = filterTree({ node: { content: this.props.factors }, predicate });

      this.setState({ factors: newFactors && newFactors.content, isSearch: true });
    } else {
      this.setState({ factors: this.props.factors, isSearch: false });
    }
  };

  public render() {
    const { factors } = this.state;
    const isEmpty = !(factors && factors.length);

    return (
      <Factors onSearch={this.handleSearch} isEmpty={isEmpty} {...this.props} {...this.state} />
    );
  }
}

export default FactorsContainer;
