import { connect } from 'react-redux';
import { ThunkDispatch } from 'redux-thunk';
import { Action } from 'redux';
import {
  ConnectedDispatchProps,
  ConnectedStateProps,
  FinanceViewOwnProps,
} from './FinanceView.types';
import { Store } from '../../store/types';
import { getFinanceData, getFetchingProcess } from '../../store/selectors';
import { getFinanceDataThunk } from '../../store/thunk';
import actions from '../../store/actions';

import FinanceView from './FinanceView';

const mapStateToProps = (state: Store): ConnectedStateProps => ({
  financeData: getFinanceData(state),
  isFetching: getFetchingProcess(state),
});

const mapDispatchToProps = (
  dispatch: ThunkDispatch<Store, {}, Action>,
): ConnectedDispatchProps => ({
  getFinanceData: (accountId: number) => {
    dispatch(getFinanceDataThunk(accountId));
  },
  clearFinanceData: () => {
    dispatch(actions.clearData());
  },
});

export default connect<ConnectedStateProps, ConnectedDispatchProps, FinanceViewOwnProps, Store>(
  mapStateToProps,
  mapDispatchToProps,
)(FinanceView);
