import React, { PureComponent } from 'react';
import Block from 'pages/accounts/modules/info/containers/Block';
import Finance from 'components/Finance/index';
import css from './FinanceView.module.css';
import { FinanceViewProps } from './FinanceView.types';
import i18nKeySet from './FinanceView.constants';

class FinanceView extends PureComponent<FinanceViewProps> {
  componentDidMount() {
    const { client } = this.props;
    this.props.getFinanceData(client);
  }

  componentWillUnmount() {
    this.props.clearFinanceData();
  }

  render() {
    const { access, financeData } = this.props;
    if (financeData) {
      return (
        <Block withoutHeader access={access} color="#FF8B8B">
          <div className={css.b}>
            <Finance title={i18nKeySet.layoutTitle} financeData={financeData} />
          </div>
        </Block>
      );
    }
    return null;
  }
}

export default FinanceView;
