import { FinanceData } from '../../store/types';

export interface FinanceViewOwnProps {
  client: number;
  access: number;
}

export interface ConnectedStateProps {
  financeData: FinanceData | null;
  isFetching: boolean;
}

export interface ConnectedDispatchProps {
  getFinanceData: (accountId: number) => void;
  clearFinanceData: () => void;
}

export type FinanceViewProps = ConnectedStateProps & ConnectedDispatchProps & FinanceViewOwnProps;
