import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { SLICE_NAME } from './constants';
import { InitialState } from './types';

const initialState: InitialState = {
  isFetching: false,
  data: null,
};

export const accountFinanceSlice = createSlice({
  name: SLICE_NAME,
  initialState,
  reducers: {
    setData: (state, { payload }: PayloadAction<InitialState['data']>) => {
      return {
        ...state,
        data: payload,
      };
    },

    clearData: (state) => {
      return {
        ...state,
        data: null,
      };
    },

    startFetch: (state) => {
      return {
        ...state,
        isFetching: true,
      };
    },

    finishFetch: (state) => {
      return {
        ...state,
        isFetching: false,
      };
    },
  },
});

export default accountFinanceSlice.reducer;
