import { Dispatch } from 'redux';
import { ThunkAction } from 'redux-thunk';
import { Action } from 'redux';
import actions from './actions';
import { Store } from './types';
import { getFinanceDataRequest } from '../api';

export const getFinanceDataThunk = (
  accoundId: number,
): ThunkAction<void, Store, {}, Action> => async (dispatch: Dispatch<Store>) => {
  dispatch(actions.startFetch());
  getFinanceDataRequest(accoundId)
    .then((data) => {
      dispatch(actions.setData(data));
    })
    .finally(() => {
      dispatch(actions.finishFetch());
    });
};
