import React from 'react';
import cx from 'classnames';
import { wordBreak } from 'components/WordBreak';

interface Props {
  className?: string;
  spaceAfter?: boolean;
  name?: string;
  text?: React.ReactNode;
  children?: React.ReactNode;
}

const Label = ({ name, text, children, spaceAfter, className }: Props) => (
  <label htmlFor={name} className={cx(className, wordBreak)}>
    {text || children}
    {spaceAfter ? <span>&nbsp;</span> : null}
  </label>
);

Label.defaultProps = {
  spaceAfter: true,
  className: undefined,
  name: undefined,
  text: undefined,
  children: undefined,
};

export default Label;
