import React from 'react';
import PropTypes from 'prop-types';
import AccountLink from 'pages/accounts/components/AccountLink';
import Preview from './index';

const render = item => `${item.name}${item.organization ? ` (${item.organization.name})` : ''}`;

const AccountPreview = props => {
  const { value } = props;

  let renderValue = null;
  if (value && value.id) {
    renderValue = <AccountLink accountId={value.id}>{render(value)}</AccountLink>;
  }

  return <Preview value={renderValue} />;
};

AccountPreview.propTypes = {
  value: PropTypes.instanceOf(Object),
};

AccountPreview.defaultProps = {
  value: {},
};

export default AccountPreview;
