import React from 'react';
import PreviewValue from 'components/PreviewValue';
import { wordBreak } from 'components/WordBreak';
import cx from 'classnames';
import css from './input.modules.scss';

interface Props {
  value: any;
}

const PreviewInput = (props: Props) => {
  const { value } = props;

  return <PreviewValue className={cx(css.common, wordBreak)} value={value} />;
};

export default PreviewInput;
