import React from 'react';
import PropTypes from 'prop-types';
import { Link as RouterLink } from 'react-router-dom';
import ExternalLinks from 'components/ExternalLinks';
import css from './input.modules.scss';

const LinkPreview = props => {
  const { value, href, isExternal } = props;
  let result;

  if (value) {
    if (isExternal) {
      result = <ExternalLinks value={value} />;
    } else if (href) {
      result = (
        <RouterLink to={href} target="_blank">
          {value}
        </RouterLink>
      );
    }
  }

  return <span className={css.preview}>{result || <span>&mdash;</span>}</span>;
};

LinkPreview.propTypes = {
  value: PropTypes.string,
  href: PropTypes.string,
  isExternal: PropTypes.bool,
};

LinkPreview.defaultProps = {
  value: undefined,
  href: undefined,
  isExternal: false,
};

export default LinkPreview;
