import React from 'react';

const ToggleEditField = props => {
  const { editComponent, previewComponent, previewProps, afterPreviewView, ...other } = props;
  if (props.isEdit) {
    const EditComponent = editComponent;
    return (EditComponent && <EditComponent {...other} />) || null;
  }

  const PreviewComponent = previewComponent;

  const { value } = other.input;

  return (
    (PreviewComponent && (
      <React.Fragment>
        <PreviewComponent value={value} {...previewProps} />
        {afterPreviewView}
      </React.Fragment>
    )) ||
    null
  );
};

export default ToggleEditField;
