// TODO: задача на рефакторинг https://st.yandex-team.ru/CRM-10138
// eslint-disable-next-line no-use-before-define
import React from 'react';
import PropTypes from 'prop-types';
import forOwn from 'lodash/forOwn';
import { reduxForm, reset, propTypes } from 'redux-form';
import ClientExternalLinks from 'components/ClientExternalLinks';
import Button from '@crm/components/dist/lego2/Button';
import Access from 'utils/Access';
import fixReinitialize from 'utils/reduxForm/fixReinitialize';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import Toolbar from 'components/Toolbar';
import PreviewStaff from 'components/PreviewValue/PreviewStaff';
import PreviewAccount from 'components/PreviewValue/PreviewAccount';
import PreviewDictionary from 'components/PreviewValue/PreviewDictionary';
import { unv } from 'utils/common';
import { CLIENT_TYPE } from 'constants/backendTypes';
import * as keyset from './info.i18n';
import ClientInput from './components/ClientInput';
import css from './styles.module.css';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nType = i18n('type');
const i18nClientId = i18n('clientId');
const i18nName = i18n('name');
const i18nOrganization = i18n('organization');
const i18nLogin = i18n('login');
const i18nMetrikaLogin = i18n('metrikaLogin');
const i18nVip = i18n('vip');
const i18nDifficultClient = i18n('difficultClient');
const i18nFreelancer = i18n('freelancer');
const i18nInfluencer = i18n('influencer');
const i18nPseudoagency = i18n('pseudoagency');
const i18nAgencyType = i18n('agencyTypes');
const i18nProductSpecificity = i18n('productSpecificities');
const i18nConsolidation = i18n('consolidatedAccounts');
const i18nTier = i18n('tier');
const i18nFreezeTier = i18n('freezeTier');
const i18nWelcomeZone = i18n('welcomeZone');
const i18nGrade = i18n('grade');
const i18nBrand = i18n('brand');
const i18nIndustryComdep = i18n('industryOld');
const i18nIndustry = i18n('industryComdep');
const i18nDomain = i18n('domain');
const i18nMarketDomain = i18n('marketDomain');
const i18nAgency = i18n('agency');
const i18nActiveClients = i18n('activeClients');
const i18nForAMonth = i18n('forAMonth');
const i18nContractors = i18n('contractors');
const i18nManagers = i18n('managers');
const i18nFreezeManager = i18n('freezeManager');
const i18nOffice = i18n('office');
const i18nCity = i18n('city');
const i18nCurrency = i18n('currency');
const i18nIsEcom = i18n('isEcom');
const i18nIsMostTrafficEcom = i18n('isMostTrafficEcom');
const i18nTerritory = i18n('territory');
const i18nUnmanagedReason = i18n('unmanagedReason');
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');
const i18nEdit = commonI18n('edit');

const INDUSTRY_DIRECTIONS = ['bottom-left'];

const NESTED_VALUES = [
  'tier',
  'freezeTier',
  'grade',
  'brand',
  'industry',
  'city',
  'territory',
  'unmanagedReason',
  'industryComdep',
];
const ARRAY = [
  'contractors',
  'managers',
  'agencyTypes',
  'productSpecificities',
  'consolidatedAccounts',
];

const PreviewAccountDiff = (props) =>
  React.createElement(PreviewAccount, {
    organization: true,
    ...props,
  });

const PreviewStaffDiff = (props) =>
  React.createElement(PreviewStaff, {
    crmPosition: true,
    ...props,
  });

class InfoForm extends React.Component {
  static propTypes = {
    ...propTypes,
    accessFields: PropTypes.instanceOf(Object),
  };

  static defaultProps = {
    accessFields: {},
  };

  constructor(props) {
    super(props);

    this.state = { isEdit: false };
  }

  getAccessFields = () => {
    const { accessFields } = this.props;
    return Object.keys(accessFields).reduce(
      (pv, cv) => ({
        ...pv,
        [cv]: Access.and(accessFields[cv], Access.create({ read: true, edit: this.state.isEdit })),
      }),
      {},
    );
  };

  handleSubmit = (values, dispatch, props) => {
    const { initialValues = {} } = props;

    const newValues = {};
    forOwn(values, (value, key) => {
      if (value !== initialValues[key]) {
        if (NESTED_VALUES.indexOf(key) !== -1) {
          newValues[key] = { value: (value && value.id) || undefined, updated: true };
        } else if (ARRAY.includes(key)) {
          newValues[key] = { value: (value || []).map((v) => Object(v).id), updated: true };
        } else {
          newValues[key] = { value, updated: true };
        }
      }
    });
    return props.onSubmit(newValues, values).then(() => {
      if (this) {
        this.handleToggleEdit();
        this.props.reload();
      }
    });
  };

  handleToggleEdit = (flag) => {
    const { isEdit } = this.state;

    this.setState({ isEdit: unv(flag, !isEdit) });
  };

  handleEdit = () => {
    this.handleToggleEdit(true);
  };

  handleCancel = () => {
    this.props.dispatch(reset(this.props.form));
    this.handleToggleEdit(false);
  };

  render() {
    const {
      handleSubmit,
      pristine,
      submitting,
      info,
      services,
      agencyStat,
      agency,
      access,
      commits,
    } = this.props;
    const accessFields = this.getAccessFields();

    return (
      <form onSubmit={handleSubmit(this.handleSubmit)}>
        <div className={css.infoRow}>
          {Access.isRead(accessFields.type) && (
            <span>
              <span className={css.infoLabel}>{i18nType}</span>
              {CLIENT_TYPE[info.type]}
            </span>
          )}
          {Access.isRead(accessFields.clientId) && (
            <span>
              <span className={css.infoLabel}>{i18nClientId}</span>
              {info.clientId || '-'}
            </span>
          )}
          <ClientExternalLinks className={css.serviceLinks} client={{ info, services }} />
        </div>
        <div>
          <ClientInput
            name="name"
            access={accessFields.name}
            editComponent="TextInput"
            type="text"
            labelText={i18nName}
            commits={commits.name}
          />
          <ClientInput
            name="organization"
            access={accessFields.organization}
            labelText={i18nOrganization}
            value={info.organization}
            previewComponent="PreviewDictionary"
            preview
            commits={commits.organization}
          />
          <ClientInput
            name="login"
            value={info.login}
            access={accessFields.login}
            editComponent="TextInput"
            type="text"
            labelText={i18nLogin}
            commits={commits.login}
          />
          <ClientInput
            name="loginMetrika"
            value={info.loginMetrika}
            access={accessFields.loginMetrika}
            editComponent="TextInput"
            type="text"
            labelText={i18nMetrikaLogin}
            commits={commits.loginMetrika}
          />
          <ClientInput
            labelText={i18nVip}
            name="isVip"
            access={accessFields.isVip}
            editComponent="CheckBox"
            previewComponent="CheckboxPreview"
            size="m"
            commits={commits.isVip}
          />
          <ClientInput
            labelText={i18nDifficultClient}
            name="isDifficultClient"
            access={accessFields.isDifficultClient}
            editComponent="CheckBox"
            previewComponent="CheckboxPreview"
            size="m"
            commits={commits.isDifficultClient}
          />
          <ClientInput
            labelText={i18nFreelancer}
            name="isFreelancer"
            access={accessFields.isFreelancer}
            editComponent="CheckBox"
            previewComponent="CheckboxPreview"
            size="m"
            commits={commits.isFreelancer}
          />
          <ClientInput
            labelText={i18nInfluencer}
            name="isInfluencer"
            access={accessFields.isInfluencer}
            editComponent="CheckBox"
            previewComponent="CheckboxPreview"
            size="m"
            commits={commits.isInfluencer}
          />
          <ClientInput
            labelText={i18nPseudoagency}
            name="isPseudoagency"
            access={accessFields.isPseudoagency}
            editComponent="CheckBox"
            previewComponent="CheckboxPreview"
            size="m"
            commits={commits.isPseudoagency}
          />
          <ClientInput
            name="tier"
            access={accessFields.tier}
            previewComponent="PreviewDictionary"
            editComponent="TierInput"
            labelText={i18nTier}
            size="xs"
            isSingleValue
            commits={commits.tier}
          />
          <ClientInput
            name="agencyTypes"
            labelText={i18nAgencyType}
            access={accessFields.agencyTypes}
            editComponent="DictionaryInput"
            previewComponent="ArrayPreviewDictionary"
            url="/dicts/agencyTypes"
            size="xs"
            commits={commits.agencyTypes}
            commitComponent={PreviewDictionary}
          />
          <ClientInput
            name="productSpecificities"
            labelText={i18nProductSpecificity}
            access={accessFields.productSpecificities}
            editComponent="DictionaryInput"
            previewComponent="ArrayPreviewDictionary"
            url="/dicts/productSpecificities"
            size="xs"
            commits={commits.productSpecificities}
            commitComponent={PreviewDictionary}
          />
          <ClientInput
            name="consolidatedAccounts"
            labelText={i18nConsolidation}
            access={accessFields.consolidatedAccounts}
            editComponent="ContractorArrayInput"
            previewComponent="ArrayPreviewAccount"
            previewProps={{
              organization: true,
              managers: true,
              showPhoneStatus: true,
            }}
            size="xs"
            commits={commits.consolidatedAccounts}
            commitComponent={PreviewAccountDiff}
          />
          <ClientInput
            name="freezeTier"
            access={accessFields.freezeTier}
            previewComponent="PreviewDictionary"
            editComponent="TierInput"
            labelText={i18nFreezeTier}
            size="xs"
            isSingleValue
            commits={commits.freezeTier}
          />
          <ClientInput
            labelText={i18nWelcomeZone}
            name="welcomeZone"
            access={accessFields.welcomeZone}
            editComponent="CheckBox"
            previewComponent="CheckboxPreview"
            size="m"
            commits={commits.welcomeZone}
          />
          <ClientInput
            name="grade"
            access={accessFields.grade}
            previewComponent="PreviewDictionary"
            editComponent="GradeInput"
            labelText={i18nGrade}
            size="xs"
            isSingleValue
            commits={commits.grade}
          />
          <ClientInput
            name="brand"
            labelText={i18nBrand}
            access={accessFields.brand}
            editComponent="BrandInput"
            previewComponent="PreviewDictionary"
            size="xs"
            isSingleValue
            commits={commits.brand}
          />
          <ClientInput
            name="industry"
            previewProps={{ fieldName: 'fullPath' }}
            previewComponent="PreviewDictionary"
            directions={INDUSTRY_DIRECTIONS}
            access={accessFields.industry}
            labelText={i18nIndustry}
            editComponent="TreeInput"
            comboInputField="fullPath"
            endpoint="/view/client/industry/list"
            size="xs"
            commits={commits.industryOld}
          />
          <ClientInput
            name="industryComdep"
            previewProps={{ fieldName: 'fullPath' }}
            previewComponent="PreviewDictionary"
            directions={INDUSTRY_DIRECTIONS}
            access={accessFields.industryComdep}
            labelText={i18nIndustryComdep}
            editComponent="TreeInput"
            comboInputField="fullPath"
            endpoint="/view/client/industry/comdep/list"
            size="xs"
            commits={commits.industryComdep}
          />
          <ClientInput
            name="domain"
            value={info.domain}
            access={accessFields.domain}
            labelText={i18nDomain}
            editComponent="TextInput"
            type="text"
            previewComponent="LinkPreview"
            previewProps={{
              isExternal: true,
            }}
            commits={commits.domain}
          />
          <ClientInput
            name="marketDomain"
            value={info.marketDomain}
            access={accessFields.marketDomain}
            labelText={i18nMarketDomain}
            editComponent="TextInput"
            type="text"
            previewComponent="LinkPreview"
            previewProps={{
              isExternal: true,
            }}
            commits={commits.marketDomain}
          />
          {Access.isRead(accessFields.agency) && agency && (
            <ClientInput
              value={agency}
              access={Access.TYPES.readonly}
              preview
              labelText={i18nAgency}
              previewComponent="PreviewAccount"
              previewProps={{
                organization: true,
                managers: true,
                showPhoneStatus: true,
              }}
            />
          )}
          {Access.isRead(accessFields.agencyActiveClientCount) && agencyStat && (
            <ClientInput
              value={agencyStat.activeClientCount}
              access={Access.TYPES.readonly}
              preview
              labelText={i18nActiveClients}
              labelSubText={i18nForAMonth}
            />
          )}
          <ClientInput
            labelText={i18nContractors}
            name="contractors"
            access={accessFields.contractors}
            editComponent="ContractorArrayInput"
            previewComponent="ArrayPreviewAccount"
            previewProps={{
              organization: true,
              managers: true,
              showPhoneStatus: true,
            }}
            size="xs"
            commits={commits.contractors}
            commitComponent={PreviewAccountDiff}
          />
          <ClientInput
            name="managers"
            labelText={i18nManagers}
            access={accessFields.managers}
            editComponent="StaffInput"
            previewComponent="ArrayPreviewStaff"
            size="xs"
            commits={commits.managers}
            commitComponent={PreviewStaffDiff}
            onlyActive
            previewProps={{
              crmPosition: true,
              showPhoneStatus: true,
            }}
          />
          <ClientInput
            name="freezeManager"
            labelText={i18nFreezeManager}
            access={accessFields.freezeManager}
            editComponent="StaffInput"
            isSingleValue
            previewComponent="ArrayPreviewStaff"
            size="xs"
            commits={commits.freezeManager}
            commitComponent={PreviewStaffDiff}
            onlyActive
            previewProps={{
              crmPosition: true,
              showPhoneStatus: true,
            }}
          />
          <ClientInput
            name="office"
            access={accessFields.office}
            value={info.office}
            editComponent="TextInput"
            type="text"
            labelText={i18nOffice}
            commits={commits.office}
          />
          <ClientInput
            name="city"
            access={accessFields.city}
            value={info.city}
            previewComponent="CityPreview"
            editComponent="CityInput"
            labelText={i18nCity}
            size="xs"
            commits={commits.city}
          />
          <ClientInput
            name="currency"
            access={accessFields.currency}
            value={''}
            previewComponent="CurrencyPreview"
            labelText={i18nCurrency}
            size="xs"
            commits={commits.currency}
          />
          <ClientInput
            name="territory"
            labelText={i18nTerritory}
            access={accessFields.territory}
            editComponent="TerritoryInput"
            previewComponent="PreviewDictionary"
            size="xs"
            isSingleValue
            commits={commits.territory}
          />
          <ClientInput
            labelText={i18nIsEcom}
            name="isEcom"
            access={accessFields.isEcom}
            editComponent="CheckBox"
            previewComponent="CheckboxPreview"
            size="m"
            commits={commits.isEcom}
          />
          <ClientInput
            labelText={i18nIsMostTrafficEcom}
            name="isMostTrafficEcom"
            access={accessFields.isMostTrafficEcom}
            editComponent="CheckBox"
            previewComponent="CheckboxPreview"
            size="m"
            commits={commits.isMostTrafficEcom}
          />
          <ClientInput
            name="unmanagedReason"
            labelText={i18nUnmanagedReason}
            access={accessFields.unmanagedReason}
            editComponent="UnmanagedReasonInput"
            previewComponent="PreviewDictionary"
            size="xs"
            isSingleValue
            commits={commits.unmanagedReason}
          />
        </div>
        {Access.isEdit(access) &&
          (this.state.isEdit ? (
            <Toolbar>
              <Button type="submit" view="action" disabled={pristine || submitting} size="xs">
                {i18nSave}
              </Button>
              <Button view="pseudo" onClick={this.handleCancel} size="xs">
                {i18nCancel}
              </Button>
            </Toolbar>
          ) : (
            <div>
              <Button view="pseudo" onClick={this.handleEdit} size="xs">
                {i18nEdit}
              </Button>
            </div>
          ))}
      </form>
    );
  }
}

export default fixReinitialize(reduxForm()(InfoForm));
