import React from 'react';
import Block from 'pages/accounts/modules/info/components/Block';
import { IssueList } from 'modules/issues';
import createI18N from '@yandex-int/i18n';
import * as keyset from './issues.i18n';

const i18nTitle = createI18N(keyset)('title');

interface Props {
  access: number;
  accountId: number;
}

const style = {
  maxHeight: 400,
};

class Issues extends React.Component<Props> {
  public getParamExtension = () => ({ accountId: this.props.accountId });

  public render() {
    const { access, accountId } = this.props;

    return (
      <Block style={style} color="#66C7FF" access={access} title={i18nTitle}>
        <IssueList
          hash={accountId}
          hasInfiniteScroll
          getParamExtension={this.getParamExtension}
          destroyOnUnmount
        />
      </Block>
    );
  }
}

export default Issues;
