import { apiCall, baseCallApi } from 'api/common';

const api = {
  get: () => apiCall('/view/account/monetizators'),
  add: (id, tagId) => baseCallApi({
    url: '/actions/account/monetizators/save',
    type: 'post',
    data: {
      accountId: id,
      tagId,
    },
  }),
  remove: (id, tagId) => baseCallApi({
    url: '/actions/account/monetizators/remove',
    type: 'post',
    data: {
      accountId: id,
      tagId,
    },
  }),
};

export default api;
