import React from 'react';
import PropTypes from 'prop-types';
import { TagsManage as Tags, TagAuthor } from 'modules/tags';
import api from './api';

const Monetizators = (props) => {
  const {
    id,
    ...passPropsThrough
  } = props;
  const tagsName = `Monetizators${id}`;

  return (
    <Tags
      name={tagsName}
      getTags={() => api.get()}
      addTag={tagId => api.add(id, tagId)}
      removeTag={tagId => api.remove(id, tagId)}
      tagComponent={TagAuthor}
      canCreate={false}
      {...passPropsThrough}
    />
  );
};

Monetizators.propTypes = {
  id: PropTypes.number.isRequired,
};

export default Monetizators;
