import React from 'react';
import PropTypes from 'prop-types';
import Block from 'pages/accounts/modules/info/components/Block';
import createI18N from '@yandex-int/i18n';
import * as keyset from './products.i18n';
import ProductsFormContainer from './ProductsFormContainer';

const i18nTitle = createI18N(keyset)('title');

const Products = props => {
  const { access } = props;
  return (
    <Block title={i18nTitle} access={access} color="#66C7FF">
      <ProductsFormContainer {...props} />
    </Block>
  );
};

Products.propTypes = {
  access: PropTypes.number,
};

Products.defaultProps = {
  access: 0,
};

export default Products;
