import React from 'react';
import PropTypes from 'prop-types';
import { reduxForm, Field, FieldArray, propTypes } from 'redux-form';
import Button from '@crm/components/dist/lego2/Button';
import Toolbar from 'components/Toolbar';
import Access from 'utils/Access';
import CheckBox from 'lego/redux-form/CheckBox';
import FieldRow from 'pages/accounts/modules/info/modules/info/components/FieldRow';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import css from './Products.modules.scss';

const commonI18n = createI18N(commonKeyset);
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');
const i18nEdit = commonI18n('edit');

const renderProducts = ({ fields, data, isEdit }) => (
  <div className={css.Products__list}>
    {fields.map((product, index) => (
      <FieldRow key={product}>
        <Field
          key={product}
          name={`${product}.selected`}
          component={CheckBox}
          size="s"
          disabled={!isEdit}
        >
          {data.products[index].name}
        </Field>
      </FieldRow>
    ))}
  </div>
);

renderProducts.propTypes = {
  fields: PropTypes.instanceOf(Object).isRequired,
  data: PropTypes.instanceOf(Object).isRequired,
  isEdit: PropTypes.bool.isRequired,
};

const ProductsForm = (props) => {
  const { handleSubmit, pristine, submitting, access, data, onCancel, onEdit, isEdit } = props;

  return (
    <form onSubmit={handleSubmit}>
      <FieldArray name="products" component={renderProducts} data={data} isEdit={isEdit} />
      {Access.isEdit(access) &&
        (isEdit ? (
          <Toolbar>
            <Button type="submit" view="action" disabled={pristine || submitting} size="xs">
              {i18nSave}
            </Button>
            <Button view="pseudo" onClick={onCancel} size="xs">
              {i18nCancel}
            </Button>
          </Toolbar>
        ) : (
          <div>
            <Button view="pseudo" onClick={onEdit} size="xs">
              {i18nEdit}
            </Button>
          </div>
        ))}
    </form>
  );
};

ProductsForm.propTypes = {
  ...propTypes,
  data: PropTypes.instanceOf(Array),
};

ProductsForm.defaultProps = {
  data: [],
};

export default reduxForm()(ProductsForm);
