import React from 'react';
import PropTypes from 'prop-types';
import { jsonApiCall } from 'api/common';
import { reset } from 'redux-form';
import { connect } from 'react-redux';
import { unv } from 'utils/common';
import ProductsForm from './ProductsForm';

class ProductsFormContainer extends React.Component {
  static propTypes = {
    data: PropTypes.instanceOf(Array),
    dispatch: PropTypes.func.isRequired,
  }

  static defaultProps = {
    data: [],
  }

  constructor(props) {
    super(props);

    this.form = 'products';
    this.state = { isEdit: false };
  }

  onSubmit = data => jsonApiCall({
    url: '/actions/account/products/save',
    data,
  }).then(() => {
    this.data = data;
    this.handleToggleEdit(false);
  });

  handleToggleEdit = (flag) => {
    this.setState({ isEdit: unv(flag, !this.state.isEdit) });
  }

  handleEdit = () => {
    this.handleToggleEdit(true);
  }

  handleCancel = () => {
    this.props.dispatch(reset(this.form));
    this.handleToggleEdit(false);
  }

  render() {
    const { data } = this.props;

    return React.createElement(ProductsForm, {
      form: this.form,
      initialValues: this.data || data,
      onSubmit: this.onSubmit,
      onEdit: this.handleEdit,
      onCancel: this.handleCancel,
      isEdit: this.state.isEdit,
      enableReinitialize: true,
      ...this.props,
    });
  }
}

export default connect()(ProductsFormContainer);
