import React, { FC, useState } from 'react';
import Dropdown from '@crm/components/dist/lego2/Dropdown';
import Menu from '@crm/components/dist/lego2/Menu';
import { OrderReportProps, Report } from './OrderReport.types';

export const OrderReport: FC<OrderReportProps> = (props) => {
  const { reports = [] } = props;
  const [isLoading, setIsLoading] = useState(false);

  const handleChange = (event: { target: { value: string } }) => {
    const report = reports.find((element) => element.id === Number(event.target.value)) as Report;
    setIsLoading(true);
    props
      .onOrder(report.url)
      .then((url) => {
        window.open(decodeURIComponent(url), '_blank');
      })
      .finally(() => {
        setIsLoading(false);
      });
  };

  return (
    <Dropdown
      view="pseudo"
      content={
        <Menu
          disabled={isLoading}
          items={reports.map((report) => ({
            value: String(report.id),
            content: report.name,
          }))}
          onChange={handleChange}
        />
      }
    >
      Заказать отчет April
    </Dropdown>
  );
};
