import { SvgIconType } from '@crm/components/dist/lego2/Icon/svg';
import { ReportName } from '../../../../../types';

interface ActionMap {
  text: Record<ReportName, string>;
  icon: Record<ReportName, SvgIconType>;
  clickHandler: Record<ReportName, string>;
}

export const actionMap: ActionMap = {
  text: {
    link: 'Ссылка на отчет',
    copy: 'Скопировать',
    restart: 'Перезапустить',
    restore: 'Восстановить удаленную задачу',
    make_pptx: 'Создать pptx презентацию',
    query_stats: 'Выгрузка неохвата для задач аналитики по запросам и по семантике кампаний',
    partial_results: 'Скачать частичные результаты',
    download: 'Скачать',
    cancel: 'Отменить',
    delete: 'Удалить',
  },
  icon: {
    link: 'share',
    copy: 'copy',
    restart: 'autorenew',
    restore: 'restore',
    make_pptx: 'noteAdd',
    query_stats: 'insertChart',
    partial_results: 'download',
    download: 'download',
    cancel: 'clear',
    delete: 'mainToolbarDelete',
  },
  clickHandler: {
    link: 'onLink',
    copy: 'onCopy',
    restart: 'onRestart',
    restore: 'onRestore',
    make_pptx: 'onCreatePptx',
    query_stats: 'onStats',
    partial_results: 'onPartialDownload',
    download: 'onDownload',
    cancel: 'onCancel',
    delete: 'onDelete',
  },
};
