import React, { FC, useCallback } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import { actionMap } from './ActionFactory.constants';
import { ActionFactoryProps } from './ActionFactory.types';
import { createClickHandler } from './ActionFactory.utils';
import { LinkButton } from './LinkButton';

export const ActionFactory: FC<ActionFactoryProps> = (props) => {
  const { name } = props;
  const text = actionMap.text[name];
  const iconProvider = useCallback(
    (iconCls) => <Icon svg={actionMap.icon[name]} className={iconCls} />,
    [name],
  );

  if (props.name === 'link') {
    return <LinkButton {...props} />;
  }

  return (
    <Button
      className={props.className}
      view="pseudo"
      title={text}
      size="xs"
      onClick={createClickHandler(name, props)}
      icon={iconProvider}
    />
  );
};
