import { ReportName } from '../../../../../types';
import { ActionFactoryProps } from './ActionFactory.types';
import { actionMap } from './ActionFactory.constants';

export const createClickHandler = (name: ReportName, props: ActionFactoryProps): (() => void) => {
  const clickHandler = props[actionMap.clickHandler[name]];
  return () => {
    if (clickHandler) {
      clickHandler(props.url);
    }
  };
};
