import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import CopyButton from 'lego/components/CopyButton';
import { actionMap } from './ActionFactory.constants';
import { ActionFactoryProps } from './ActionFactory.types';

const iconProvider = (iconCls) => <Icon svg={actionMap.icon.link} className={iconCls} />;

export const LinkButton: FC<ActionFactoryProps> = (props) => {
  const { url, className } = props;
  const text = actionMap.text.link;

  return (
    <CopyButton
      className={className}
      copy={url}
      iconProvider={iconProvider}
      size="xs"
      view="pseudo"
      tooltipDirection="left-center"
      withTooltip
      title={text}
    />
  );
};
