import React, { FC } from 'react';
import { ActionFactory } from './ActionFactory';
import { ActionsProps } from './Actions.types';
import css from './Actions.module.css';

export const Actions: FC<ActionsProps> = (props) => {
  const openNewTab = (url: string) => {
    props.onClick(url).then((url) => {
      window.open(decodeURIComponent(url), '_blank');
    });
  };

  return (
    <div className={css.Actions}>
      {props.actions.map((action) => (
        <ActionFactory
          key={action.name}
          name={action.name}
          url={action.url}
          className={css.Actions__action}
          onCopy={openNewTab}
          onPartialDownload={openNewTab}
          onDownload={openNewTab}
          onStats={openNewTab}
          onRestart={openNewTab}
          onRestore={openNewTab}
          onCancel={openNewTab}
          onCreatePptx={openNewTab}
          onDelete={openNewTab}
        />
      ))}
    </div>
  );
};
