import React, { FC } from 'react';
import AccountLink from 'pages/accounts/components/AccountLink';
import { FormattedDate } from 'react-intl';
import StaffCard from 'components/StaffCard';
import { Actions } from './Actions';
import { ReportParams } from './ReportParams';
import { ReportProps } from './Report.types';
import css from './Report.module.css';
import { ReportType } from './ReportType';

export const Report: FC<ReportProps> = (props) => {
  const { report } = props;

  return (
    <div className={css.Report} style={props.style}>
      <div className={css.Report__type}>
        <ReportType typeId={report.typeId} />
      </div>
      <div className={css.Report__name}>
        {report.name}
        {report.renderedParamsHtml && report.renderedParamsHtml.length && (
          <ReportParams reportParams={report.renderedParamsHtml} />
        )}
      </div>
      <div className={css.Report__author}>
        <StaffCard user={report.author} theme="yandex" />
      </div>
      <div className={css.Report__status}>{report.status}</div>
      <div className={css.Report__accounts}>
        {report.accounts.map((account) => (
          <AccountLink
            title={account.name}
            className={css.Report__account}
            key={account.id}
            account={account}
          />
        ))}
      </div>
      <div className={css.Report__lastModified}>
        <FormattedDate value={report.lastModified} />
      </div>
      <div className={css.Report__actions}>
        <Actions onClick={props.onActionClick} actions={report.actions} />
      </div>
    </div>
  );
};
