import React, { FC } from 'react';
import Dropdown from '@crm/components/dist/lego2/Dropdown';
import Icon from '@crm/components/dist/lego2/Icon';
import { ReportParamsProps } from './ReportParams.types';
import css from './ReportParams.module.css';

export const ReportParams: FC<ReportParamsProps> = (props) => {
  return (
    <Dropdown
      view="clear"
      content={
        <div className={css.ReportParams__content}>
          <iframe srcDoc={props.reportParams} />
        </div>
      }
    >
      <Icon className={css.ReportParams__icon} svg="info" />
    </Dropdown>
  );
};
