import React, { FC, useRef, useEffect, useCallback } from 'react';
import Block from 'pages/accounts/modules/info/containers/Block';
import { ListChildComponentProps } from 'react-window';
import { VirtualList } from 'components/InfiniteList';
import { ReportsProps } from './Reports.types';
import { BLOCK_COLOR, BLOCK_TITLE, ROW_SIZE, ACCOUNT_LINK_HEIGHT } from './constants';
import { Report } from './Report';
import { Header } from './Header';
import { OrderReport } from './OrderReport';
import css from './Reports.module.css';

const Row: FC<ListChildComponentProps> = ({ data, index, style }) => {
  return <Report report={data.reports[index]} onActionClick={data.onActionClick} style={style} />;
};

export const Reports: FC<ReportsProps> = (props) => {
  const listRef = useRef<{ resetAfterIndex: (index: number) => void }>();

  useEffect(() => {
    if (listRef.current) {
      listRef.current.resetAfterIndex(0);
    }
  }, [props.reports.length]);

  const getItemSize = useCallback(
    (index: number) => {
      const initialSize = ROW_SIZE;
      if (!props.reports.length || !props.reports[index]) {
        return initialSize;
      }

      const nonImpactCount = Math.floor(initialSize / ACCOUNT_LINK_HEIGHT);
      const size =
        props.reports[index].accounts.length > nonImpactCount
          ? (props.reports[index].accounts.length - nonImpactCount) * ACCOUNT_LINK_HEIGHT +
            initialSize
          : initialSize;

      return size;
    },
    [props.reports],
  );

  const itemData = {
    reports: props.reports,
    onActionClick: props.onActionClick,
  };

  return (
    <Block
      className={css.Reports}
      title={BLOCK_TITLE}
      padding={false}
      access={props.access || 3}
      color={BLOCK_COLOR}
      actions={<OrderReport reports={props.reportsForOrder} onOrder={props.onReportOrder} />}
    >
      <div>
        <Header />
        <VirtualList
          //@ts-ignore
          ref={listRef}
          className={css.Reports__list}
          itemSize={getItemSize}
          itemData={itemData}
          itemCount={props.reports.length}
          onLoad={props.onLoad}
          isLoading={props.isLoading}
          isEof={props.isEof}
        >
          {Row}
        </VirtualList>
      </div>
    </Block>
  );
};
