import { get } from 'entry/api/common';
import { GetReportsResponse } from './Reports.types';

export const getReports = (query: { accountId: number; offset?: number; length?: number }) => {
  const { offset, length, accountId } = query || {};

  return get<GetReportsResponse>({
    url: '/view/account/reports',
    data: {
      accountId,
      offset,
      length,
    },
    global: false,
  });
};
