export type ReportName =
  | 'link'
  | 'copy'
  | 'restart'
  | 'restore'
  | 'make_pptx'
  | 'query_stats'
  | 'partial_results'
  | 'download'
  | 'cancel'
  | 'delete';

export interface ReportAction {
  name: ReportName;
  url: string;
}

export interface CopyAction extends ReportAction {
  name: 'copy';
}

export interface LinkAction extends ReportAction {
  name: 'link';
}

export interface RestartAction extends ReportAction {
  name: 'restart';
}

export interface RestoreAction extends ReportAction {
  name: 'restore';
}

export interface CreatePptxAction extends ReportAction {
  name: 'make_pptx';
}

export interface StatsAction extends ReportAction {
  name: 'query_stats';
}

export interface PartialDownloadAction extends ReportAction {
  name: 'partial_results';
}

export interface DownloadAction extends ReportAction {
  name: 'download';
}

export interface CancelAction extends ReportAction {
  name: 'cancel';
}

export interface DeleteAction extends ReportAction {
  name: 'delete';
}

export type ReportActionType =
  | LinkAction
  | CopyAction
  | RestartAction
  | RestoreAction
  | CreatePptxAction
  | StatsAction
  | PartialDownloadAction
  | DownloadAction
  | CancelAction
  | DeleteAction;

export interface ReportAccount {
  id: number;
  name: string;
}

export enum ReportTypeId {
  April = 0,
  Tsp = 1,
}

export interface Report {
  id: number;
  typeId: ReportTypeId;
  name: string;
  author: unknown;
  renderedParamsHtml?: string;
  accounts: ReportAccount[];
  status: string;
  lastModified: string;
  actions: ReportActionType[];
}

export interface ReportAvailableForOrder {
  id: number;
  name: string;
  url: string;
}
