import React from 'react';
import cx from 'classnames';
import { wordBreak } from 'components/WordBreak';
import { LabelProps } from './Label.types';

const Label = ({ name, text, children, spaceAfter = true, className }: LabelProps) => (
  <label htmlFor={name} className={cx(className, wordBreak)}>
    {text || children}
    {spaceAfter ? <span>&nbsp;</span> : null}
  </label>
);

export default Label;
