import React from 'react';
import { wordBreak } from 'components/WordBreak';
import cx from 'classnames';
import PreviewValue from 'components/PreviewValue';
import css from './PreviewInput.modules.scss';
import { PreviewInputProps } from './PreviewInput.types';

const PreviewInput = (props: PreviewInputProps) => {
  const { value } = props;

  return <PreviewValue className={cx(css.common, wordBreak)} value={value} />;
};

export default PreviewInput;
