import { InjectedFormProps } from 'redux-form';

export interface Priority {
  id: number;
  name: string;
}

export interface Status {
  id: number;
  name: string;
}

export interface Category {
  id: number;
  name: string;
}

export interface Info {
  rsyaSspBundleId: string;
  rsyaSspPageId: string;
  rsyaSspDailyShowCount: number;
  rsyaSspDeveloper: string;
  rsyaSspInstallCount: number;
  rsyaSspLoginPi: string;
  rsyaSspPriority: Priority;
  rsyaSspStatus: Status;
  rsyaSspCategory: Category;
  rsyaDeveloperType: number;
  rsyaDeveloperStatus: number;
}

export interface AccessFields {
  rsyaSspLoginPi: number;
  rsyaSspBundleId: number;
  rsyaSspPageId: number;
  rsyaSspDeveloper: number;
  rsyaSspInstallCount: number;
  rsyaSspPriority: number;
  rsyaSspStatus: number;
  rsyaSspDailyShowCount: number;
  rsyaSspCategory: number;
  rsyaDeveloperType: number;
  rsyaDeveloperStatus: number;
}

export interface RsYaInfoState {
  isEdit: boolean;
}

export interface RsYaInfoOwnProps {
  accessFields: AccessFields;
  access: number;
  reload: () => void;
  dispatch: (arg: object) => void;
  initialValues: Partial<Info>;
}

export type RsYaInfoProps = InjectedFormProps & RsYaInfoOwnProps;
