import React from 'react';

const ToggleEditField = (props) => {
  const {
    editComponent,
    previewComponent,
    previewProps,
    afterPreviewView,
    formatEditProps,
    ...other
  } = props;
  if (props.isEdit) {
    const EditComponent = editComponent;
    let editProps = other;
    if (typeof formatEditProps === 'function') {
      editProps = formatEditProps(editProps);
    }
    return (EditComponent && <EditComponent {...editProps} />) || null;
  }

  const PreviewComponent = previewComponent;

  const { value } = other.input;

  return (
    (PreviewComponent && (
      <>
        <PreviewComponent value={value} {...previewProps} />
        {afterPreviewView}
      </>
    )) ||
    null
  );
};

export default ToggleEditField;
