/* eslint-disable no-restricted-globals */

import { jsonApiCall } from 'api/common';
import createI18N from '@yandex-int/i18n';
import * as keyset from './subAccounts.i18n';

const i18nDetachConfirm = createI18N(keyset)('detachConfirm');

const bindApi = (accountId, subAccountId, action) =>
  jsonApiCall({
    url: '/actions/account/link',
    data: {
      superAccountId: accountId,
      accountId: subAccountId,
      action,
    },
  });

export const accountConnect = (accountId, subAccount) => () =>
  bindApi(accountId, subAccount.id, 'AddLink');

export const accountDetach = (accountId, subAccountId) => () => {
  if (!confirm(i18nDetachConfirm)) {
    // eslint-disable-line no-restricted-globals
    return null;
  }

  return bindApi(accountId, subAccountId, 'RemoveLink');
};
