import React from 'react';
import PropTypes from 'prop-types';
import Block from 'pages/accounts/modules/info/components/Block';
import { PopupChangesRequest } from 'components/ChangesRequest';
import PreviewAccount from 'components/PreviewValue/PreviewAccount';
import createI18N from '@yandex-int/i18n';
import * as keyset from '../subAccounts.i18n';
import SubAccounts from '../containers/SubAccounts';
import ConnectAccount from '../containers/ConnectAccount';

const i18nAccounts = createI18N(keyset)('accounts');

const PreviewAccountInfo = props => <PreviewAccount level="info" {...props} />;

const Layout = props => {
  const { access, color, accountId, subAccountsLength, commits, reload } = props;

  return (
    <Block
      access={access}
      color={color}
      title={
        <span>
          {i18nAccounts}
          {!!subAccountsLength && `\u0020(${subAccountsLength})`}
          <PopupChangesRequest items={commits} previewComponent={PreviewAccountInfo} />
        </span>
      }
      padding={false}
      actions={<ConnectAccount accountId={accountId} onSubmitSuccess={reload} />}
    >
      <SubAccounts access={access} accountId={accountId} onSubmitSuccess={reload} />
    </Block>
  );
};

Layout.propTypes = {
  subAccountsLength: PropTypes.number,
  accountId: PropTypes.number.isRequired,
  access: PropTypes.number,
  color: PropTypes.string,
  commits: PropTypes.instanceOf(Array),
  reload: PropTypes.func.isRequired,
};

Layout.defaultProps = {
  subAccountsLength: undefined,
  access: undefined,
  color: undefined,
  commits: undefined,
};

export default Layout;
