import React from 'react';
import PropTypes from 'prop-types';
import SubAccountsHeader from './SubAccountsHeader';
import SubAccountsItem from './SubAccountsItem';
import css from './SubAccounts.modules.scss';

const SubAccounts = (props) => {
  const { access, items, accountDetach, comDepMoney } = props;

  const getAccountDetachHandler = (id) => () => accountDetach(id);
  if (Array.isArray(items) && items.length) {
    return (
      <div className={css.SubAccounts__wrap}>
        <div className={css.SubAccounts}>
          <SubAccountsHeader comDepMoney={comDepMoney} access={access} />
          <div className={css.SubAccounts__body}>
            {items.map((item, index) => (
              <SubAccountsItem
                comDepMoney={comDepMoney}
                key={item.id}
                onRemove={getAccountDetachHandler(item.id)}
                item={item}
                index={index + 1}
                access={access}
              />
            ))}
          </div>
        </div>
      </div>
    );
  }

  return null;
};

SubAccounts.propTypes = {
  accountDetach: PropTypes.func.isRequired,
  access: PropTypes.number,
  items: PropTypes.arrayOf(SubAccountsItem.propTypes.item),
};

SubAccounts.defaultProps = {
  access: undefined,
  items: [],
};

export default SubAccounts;
