import React from 'react';
import PropTypes from 'prop-types';
import Access from 'utils/Access';
import { FormattedDate } from 'react-intl';
import cx from 'classnames';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as keyset from '../subAccounts.i18n';
import css from './SubAccounts.modules.scss';

const i18n = createI18N(keyset);
const i18nRaw = createI18NRaw(keyset);
const i18nName = i18n('name');
const i18nLogin = i18n('login');
const i18nClientId = i18n('clientId');
const i18nType = i18n('type');
const i18nSpinoffFor = i18nRaw('spinoffFor', {
  date: <FormattedDate value={Date.now()} month="short" />,
});
const i18nSpinoffForComDep = i18nRaw('spinoffForComDep', {
  date: <FormattedDate value={Date.now()} month="short" />,
});
const i18nAgency = i18n('agency');
const i18nManagers = i18n('managers');
const i18nDomain = i18n('domain');

const SubAccountsHeader = (props) => {
  const { access, comDepMoney } = props;

  return (
    <div className={css.SubAccounts__header}>
      <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_index)}>#</span>
      <span className={css.SubAccounts__cell}>{i18nName}</span>
      <span className={css.SubAccounts__cell}>{i18nLogin}</span>
      <span className={css.SubAccounts__cell}>{i18nClientId}</span>
      <span className={css.SubAccounts__cell}>{i18nType}</span>
      <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_money)}>
        {i18nSpinoffFor}
      </span>
      {comDepMoney && (
        <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_money)}>
          {i18nSpinoffForComDep}
        </span>
      )}
      <span className={css.SubAccounts__cell}>{i18nAgency}</span>
      <span className={css.SubAccounts__cell}>{i18nManagers}</span>
      <span className={css.SubAccounts__cell}>{i18nDomain}</span>
      {Access.isEdit(access) && (
        <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_actions)} />
      )}
    </div>
  );
};

SubAccountsHeader.propTypes = {
  access: PropTypes.number,
};

SubAccountsHeader.defaultProps = {
  access: undefined,
};

export default SubAccountsHeader;
