import React from 'react';
import { FormattedNumber } from 'react-intl';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import Access from 'utils/Access';
import cx from 'classnames';
import AccountLink from 'pages/accounts/components/AccountLink';
import createI18N from '@yandex-int/i18n';
import Icon from 'lego/components/Icon';
import * as keyset from '../subAccounts.i18n';
import css from './SubAccounts.modules.scss';

const i18nRemoveConnection = createI18N(keyset)('removeConnection');

const getIconForButton = (iconCls) => (
  <Icon className={iconCls} pack={Icon.PACKS.MATERIAL} icon="remove" />
);

const getRenderedMoneyField = (name, field) => {
  if (field === undefined) {
    return <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_money)} />;
  }
  const value = name === 'w0Total' ? field : field.value;
  const currency = name === 'w0Total' ? 'RUB' : field.currency;

  return (
    <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_money)}>
      {/* eslint-disable-next-line react/style-prop-object */}
      <FormattedNumber value={value} style="currency" currency={currency} />
    </span>
  );
};

const SubAccountsItem = (props) => {
  const {
    index,
    item: { id, name, clientId, type, login, manager, agency, domain, w0Total, comdepW0Total },
    access,
    onRemove,
    comDepMoney,
  } = props;
  return (
    <div className={css.SubAccounts__item}>
      <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_index)}>{index}</span>
      <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_name)}>
        <AccountLink accountId={id}>{name}</AccountLink>
      </span>
      <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_login)}>{login}</span>
      <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_clientId)}>{clientId}</span>
      <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_type)}>{type}</span>
      {getRenderedMoneyField('w0Total', w0Total)}
      {comDepMoney && getRenderedMoneyField('comdepW0Total', comdepW0Total)}
      <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_name)}>
        {agency && <AccountLink accountId={agency.id}>{agency.name}</AccountLink>}
      </span>
      <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_manager)}>{manager}</span>
      <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_name)}>{domain}</span>
      {Access.isEdit(access) && (
        <span className={cx(css.SubAccounts__cell, css.SubAccounts__cell_actions)}>
          <Button
            size="xs"
            view="danger"
            title={i18nRemoveConnection}
            onClick={onRemove}
            icon={getIconForButton}
          />
        </span>
      )}
    </div>
  );
};

SubAccountsItem.propTypes = {
  index: PropTypes.number.isRequired,
  item: PropTypes.shape({
    id: PropTypes.number.isRequired,
    clientId: PropTypes.number,
    name: PropTypes.string,
    manager: PropTypes.string,
    type: PropTypes.string,
  }).isRequired,
  access: PropTypes.number,
  onRemove: PropTypes.func,
};

SubAccountsItem.defaultProps = {
  access: undefined,
  onRemove: undefined,
};

export default SubAccountsItem;
