import React from 'react';
import { connect } from 'react-redux';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import createI18N from '@yandex-int/i18n';
import { ModalForm as ClientFind } from 'modules/clientSelectForm';
import * as keyset from '../subAccounts.i18n';
import { accountConnect } from '../actions';

const i18nConnectAccount = createI18N(keyset)('connectAccount');

const ConnectAccount = (props) => {
  const { accountConnect, children, ...passPropsThrough } = props; // eslint-disable-line no-shadow

  return (
    <ClientFind name="CONNECT_ACCOUNT" onSubmit={accountConnect}>
      {(modal, open) => (
        <Button
          size="xs"
          view="pseudo"
          title={i18nConnectAccount}
          onClick={open}
          {...passPropsThrough}
        >
          {children}
          {modal}
        </Button>
      )}
    </ClientFind>
  );
};

ConnectAccount.propTypes = {
  accountConnect: PropTypes.func.isRequired,
  children: PropTypes.node,
};

ConnectAccount.defaultProps = {
  children: i18nConnectAccount,
};

const mapDispatch = (dispatch, props) => ({
  accountConnect: (subAccount) =>
    dispatch(accountConnect(props.accountId, subAccount, props.onSubmitSuccess)).then((data) => {
      const { onSubmitSuccess } = props;

      if (typeof onSubmitSuccess === 'function') {
        onSubmitSuccess();
      }

      return data;
    }),
});

export default connect(null, mapDispatch)(ConnectAccount);
